within PowerGrids.UsersGuide.Tutorial;

package ModelicaToolSupport
  extends Modelica.Icons.Information;
annotation(preferredView = "info",
    Documentation(info = "<html><head></head><body>
<h2>Modelica Tool Support</h2>
<p>The PowerGrid library has been developed using the <a href=\"https://www.openmodelica.org\">OpenModelica</a> tool and has been tested extensively using that tool. The library was written in standard Modelica language, so it is expected to work with any Modelica tool that fully supports the standard, with particular reference to Complex numbers. However, it hasn't been tested extensively with any other tool so far.</p>
<p>The power system models that can be built with this library have a different structure compared to the models that are normally simulated by Modelica tools, due to the large number of coupled implicit algebraic equations stemming from the phasor-based representation of most grid elements, such as transmission lines, transformers, and loads. This may require some special set-up of the tool to generate efficient and numerically robust code to simulate the models. These aspects are now briefly discussed.</p>
<p>The first aspect concerns the structure of the system mathematical models. The original formulation of the system model is a system of differential-algebraic equations (DAE), which has a sparse structure, since every physical component is connected to a limited number of neighbouring components. The conventional approach used by Modelica tools to solve these DAEs is to first transform them into ordinary differential equations (ODE), in a process known as causalization that requires to solve the DAEs for the state derivatives, and then to use an ODE solver to perform time integration. </p>
<p>Unfortunately, this approach is highly inefficient in the case of PowerGrids system models: it is well known from the swing equation theory that if a quasi-static phasor approximation of the grid elements is used, then the derivative of the shaft angular velocity of each synchronous generator instantaneously depends on all the rotor angles of all other synchronous generators which are connected through the grid. Hence, although the DAEs are sparse, their ODE equivalent representation is not. This makes the causalization process highly inefficient, because the computation of the right-hand side of the ODE formulation requires the computation of a large number of Jacobian matrix elements, as well as the solution of a large dense nonlinear system.&nbsp;</p>
<p>This means that, except for very simple systems with a few synchronous generators, the so called DAE-mode solution method should be selected, which avoids the standard ODE causalization and uses a native numerical DAE solver to simulate the system. In case causalization is employed, the use of sparse solvers for the implicit nonlinear equations (a.k.a. algebraic loops) is mandatory for reasons of efficiency, since the size of those systems can be quite large, while the number of variables involved in each equation is normally limited to a few units.</p>
<p>The second aspect regards the initial guess for the solver of the initialization problems. As already discussed in the previous section of the Tutorial, the PowerSystems library was designed to make sure that proper start values are computed, starting from the power flow results, for all the nonlinear variables that influence the Jacobian of the initialization problem, while there is no need to care about the initial values of variables appearing linearly in the models. According to the paper mentioned in the previous section, following this approach guarantees the convergence of the Newton algorithm to solve the initialization problem, as long as the problem is kept in its original formulation.</p><p>However, Modelica tools often employ a method, known as <i>tearing</i>, to reduce the size of the actual nonlinear implicit system to be solved, thus making the solution process more efficient. Unfortunately, the choice of nonlinear variables as torn variables leads to the loss of their initial guess values, potentially hampering the convergence.</p>
<p>To avoid these problems, it is recommended to disable the tearing algorithm, at least for systems having more than a few unknowns, while at the same time using sparse algorithms to exploit the sparse structure of the initialization problem favourably.</p>
<p>Finally, the homotopy operator is used in several places of the library, in particular for the robust solution of the nonlinear implicit equations relating internal and external parameters of the synchronous machine models. It is also used to initially remove the nonlinear elements due to actuator saturations in the control system models, making the corresponding equations linear and thus avoiding the need to provide start values for all their variables, which could be quite inconvenient.
</p><p>Hence, it is essential that the homotopy operator is indeed used in the solution process of the initialization problem, in order to avoid solver convergence problems.</p>
<p>In the case of the OpenModelica compiler, these requirements can be met by selecting the following flags:
<ul>
<li>Simulation flag <code>-homotopyOnFirstTry</code>: forces the tool to use homotopy right away when solving the initialization problem (note that this is the default behaviour since version 1.16.0, so from this version onwards setting this flag is no longer required)</li>
<li>Simulation flag <code>-nls=kinsol</code>: forces the tool to use the sparse KINSOL solver for all algebraic loops and nonlinear implicit systems.</li>
<li>Compilation flag <code>--tearingMethod=minimalTearing</code>: avoids tearing except for dealing with mixed real-integer problems.</li>
<li>Compilation flag <code>--daeMode</code>: instructs the tool to use DAE mode for the simulation of the system. This is recommened for systems having more than a handful of synchronous generators, while the default ODE mode can be used if there are only a few synchronous generators.</li>
</ul></p>
<p>Please note that as of version 1.14.1 of OpenModelica, the DAE mode and Kinsol solvers are still partially experimental, so you may need to avoid these options in case they cause code generation or runtime errors.</p>
<p>The existing example models and test models in the PowerSystems library already have <code>__OpenModelica</code> custom annotations to set those flags. In case you are creating new system models, it is recommended that you set those flags in the Simulation Setup window and save them in an annotation in the model, so that they are automatically set when the model is later re-run.</p>
<p>Indications about the set up with other Modelica tools will be provided in future versions of this library, after extensive testing has been carried out.</p>
</ul></body></html>"));
end ModelicaToolSupport;
